// uTaskerFileCreate.cpp 
//
// V1.5 solved problem with image names like "image/" being generated by V1.4
// V1.6 solved problem with images without -x controls
// V1.7 respect the colour palette of monochrome images so that an inverted image is converted as colour inverted
// V1.8 corrected conversion of 24-bit bitmaps with pixel width not divisible by 8
// V1.9 -? option converts AJAX XLM file inputs for use with embedded files - eg. "XML_test.txt" embedded as "XML?test"
// V1.10 convert 24 bit bitmaps to 16 bit format
// V1.11 allow embedded file name to be changed


#include "stdio.h"
#include <string.h>
#include "conio.h"
#include "Fcntl.h"
#include "io.h"
#include <sys/stat.h>


#define SOFTWARE_VERSION "      uTaskerFileCreate V1.11\r\r\n"

// Bit map structures as used by Windows
//
typedef struct stBITMAPHEADER {
    unsigned char  bmType[2];
    unsigned char  bmLength[4]; 
    unsigned char  bmReserved[4];
    unsigned char  bmOffBits[4];
} W_BITMAPHEADER;

typedef struct stBITMAPINFO { 
    unsigned char biSize[4]; 
    unsigned char biWidth[4]; 
    unsigned char biHeight[4]; 
    unsigned char biPlanes[2];
    unsigned char biBitCount[2];
    unsigned char biCompression[4];
    unsigned char biSizeImage[4];
    unsigned char biXPelsPerMeter[4];
    unsigned char biYPelsPerMeter[4];
    unsigned char biClrUsed[4];
    unsigned char biClrImportant[4]; 
} W_BITMAPINFO;


#define MAX_MEMORY (1024*1024)                                            // max 1M memory
static unsigned char ucInputContent[MAX_MEMORY];    
static unsigned long  ulFileLocationAddress = 0;
static char cEntries[128*1024];
static int iEntrySize = 0;
static unsigned long binary_size[128] = {0};
static int binary_entries = 0;
static char last_string[100];

static char cCode1[] = "static const unsigned char array[] = {\r\n";
static char cCode3[] = "};\r\n\n";
static char cCode4[] = "static const USER_FILE user_files[] = {\r\n";
static char cCode5[] = "{0} // end of list\r\n};\r\n";

static char file_header1[] = "/**********************************************************************\r\n   Mark Butcher    Bsc (Hons) MPhil MIET\r\n\n   M.J.Butcher Consulting\r\n   Birchstrasse 20f,    CH-5406, Rtihof\r\n   Switzerland\r\n\n   www.uTasker.com    Skype: M_J_Butcher\r\n\n   ---------------------------------------------------------------------\r\n   File:         ";
static char file_header2[] = " (created by uTaskerFileCreate V1.11)\r\n\n   Project:      uTasker project\r\n   ---------------------------------------------------------------------\r\n   Copyright (C) M.J.Butcher Consulting 2004..2010\r\n   *********************************************************************\r\n\nThis file is not linked directly in the project but is included by the GLCD task file\r\n\n*/ \n\n";

#define _TAB   0x09

#define REMOVE_WHITE_SPACE 0x00000001
#define ADD_ENTRY          0x00000002
#define ALL_FILES_ADDED    0x00000004
#define NEGATIVE_BM        0x00000008
#define INVERTED_BM        0x00000010
#define DONT_CLOSE_OUTPUT  0x00000020
#define FIRST_FILE         0x00000040
#define XML_NAME           0x00000080
#define RGB565_FORMAT      0x00000100

static char define_list[64][256];
static unsigned long ulDefineValues[64] = {0};
static int iDefines = 0;

static unsigned long fnGetDec(char *cInputBuffer)
{
    unsigned long ulValue = 0;
    while (*cInputBuffer != 0) {
        ulValue *= 10;
        ulValue += (*cInputBuffer++ - '0');
    }
    return ulValue;
}

static unsigned long fnGetHex(char *cInputBuffer)
{
    unsigned long ulValue = 0;
    unsigned char ucTemp;
    while (*cInputBuffer != 0) {
        ulValue <<= 4;
        ucTemp = (*cInputBuffer++ - '0');
        if (ucTemp > 9) {
            ucTemp -= ('a' - '9' - 1);
        }
        if (ucTemp > 0x0f) {
            ucTemp -= ('A' - 'a');
        }
        ulValue |= ucTemp;
    }
    return ulValue;
}

static char cRename[128];

static int fnGetNextInputFile(int ControlFile, unsigned long *ulOptions, char file_name[128], char mime_type[32], char file_chars[128])
{
#define FLUSHING_COMMENT           1
#define COLLECT_OPTION             2
#define ENTER_DEFINE               3
#define ENTER_DEFINE_VALUE         4
#define COLLECTING_MIME            5
#define COLLECTING_CHARACTERISTICS 6
#define COLLECT_ADDRESS            7
#define COLLECT_RENAME             8
#define COLLECT_EXTENSION          9
#define COLLECT_EXTENSION_2        10

    char cInputBuffer[256];
    int iValidInput = 0;
    int iState = 0;
    int iNewFile = 55555555;
    int iRenameLength = 0;
    *ulOptions &= ~(REMOVE_WHITE_SPACE | INVERTED_BM | NEGATIVE_BM);     // V1.2 remove options so that they are not incorrectly used
    strcpy(mime_type, "MIME_HTML");                                      // enter default mime type in case nothing is specified
    strcpy(file_chars, "FILE_VISIBLE");                                  // enter default characteristics in case nothing is specified
    cRename[0] = 0;
    while (_read(ControlFile, &cInputBuffer[iValidInput], 1)) {          // read input file, one byte at a time
        switch (iState) {
        case 0:
        case COLLECT_EXTENSION:
		case COLLECT_EXTENSION_2:
            if ((cInputBuffer[iValidInput] == '/') && ((iValidInput == 0) || (cInputBuffer[iValidInput - 1] == '/'))) { // opening a comment so ignore to end of line
                if (cInputBuffer[iValidInput - 1] == '/') {              // V1.5 7.3.2011 (avoid names ending with /)
                    cInputBuffer[iValidInput - 1] = 0;
                }
                else {
                    cInputBuffer[iValidInput] = 0;
                }
                strcpy(last_string, cInputBuffer);
                iValidInput = 0;
                iState = FLUSHING_COMMENT;
            }
            else if (cInputBuffer[iValidInput] == '#') {                 // start a define
                iValidInput = 0;
                iState = ENTER_DEFINE;
            }
            else {
                if ((cInputBuffer[iValidInput] == '\n') || (cInputBuffer[iValidInput] == '\r')) {
                    cInputBuffer[iValidInput] = 0;
                    strcpy(last_string, cInputBuffer);
                    iValidInput = 0;
                    if (iNewFile != 55555555) {                          // a file has been opened
                        return iNewFile;
                    }
                }
                else if (cInputBuffer[iValidInput] == '[') {             // optional rename
                    iState = COLLECT_RENAME;
                    iRenameLength = 0;
                }
                else if ((cInputBuffer[iValidInput] == '-') && (iState >= COLLECT_EXTENSION)) {             // option following
                    iState = COLLECT_OPTION;
                }
                else if (cInputBuffer[iValidInput] == '%') {             // physical address location following
                    iState = COLLECT_ADDRESS;
                }
                else if ((cInputBuffer[iValidInput] == ' ') || (cInputBuffer[iValidInput] == _TAB)) { // ignore white space
                    if (iState == COLLECT_EXTENSION) {                   // but if extension received it means the complete file name has been received
                        char *ptrOut, *ptrIn;
                        cInputBuffer[iValidInput] = 0;                   // terminate the string
                        ptrIn = cInputBuffer;
                        ptrOut = file_name;
                        do {
                            if (*ptrIn == '?') {
                                *ptrOut = *ptrIn;
                                *ptrIn = '-';                            // XML?dummy is opened as XML-dummy
                            }
                            else {
                                *ptrOut = *ptrIn;
                            }
                            ptrOut++;
                        } while (*ptrIn++ != 0);
                        iNewFile = _open(cInputBuffer, (_O_BINARY | _O_RDONLY));
                        iState = COLLECT_EXTENSION_2;
                        iValidInput = 0;
                    }
                }
                else if (cInputBuffer[iValidInput] == '.') {             // the dot in the file name
                    iState = COLLECT_EXTENSION;
                    iValidInput++;                                       // collect the input
                }
                else if (cInputBuffer[iValidInput] == '|') {             // special case indicating the end of a file name without extension
                    iState = COLLECT_EXTENSION;                          // following space expected
                }
                else {
                    iValidInput++;                                       // collect the input
                }
            }
            break;

        case COLLECT_ADDRESS:
            if (((cInputBuffer[iValidInput] == ' ') || (cInputBuffer[iValidInput] == _TAB)) || (cInputBuffer[iValidInput] == '/') || (cInputBuffer[iValidInput] == '\r') || (cInputBuffer[iValidInput] == '\n')) {                      // ignore white space
                cInputBuffer[iValidInput] = 0;
                ulFileLocationAddress = fnGetHex(cInputBuffer);
                iValidInput = 0;
                iState = 0;
            }
            else {
                iValidInput++;                                           // collect the input
            }
            break;

        case COLLECT_RENAME:
            if ((cInputBuffer[iValidInput] != ' ') && (cInputBuffer[iValidInput] != _TAB)) { // ignore white space
                if (cInputBuffer[iValidInput] == ']') {
                    cRename[iRenameLength] = 0;
                    iValidInput = 0;
                    iState = COLLECT_EXTENSION_2;
                }
                else {
                    cRename[iRenameLength++] = cInputBuffer[iValidInput];
                }
            }
            break;
        case COLLECT_OPTION:
            switch (cInputBuffer[iValidInput]) {
            case _TAB:
            case ' ':                                                    // ignore white space
                break;
            case 'w':                                                    // white space stripping enabled
            case 'W':
                *ulOptions |= REMOVE_WHITE_SPACE;
                iValidInput = 0;
                iState = COLLECT_EXTENSION_2;
                break;
            case 'c':                                                    // file characteristics
            case 'C':
                iValidInput = 0;
                iState = COLLECTING_CHARACTERISTICS;
                break;
            case 't':                                                    // mime type
            case 'T':
                iValidInput = 0;
                iState = COLLECTING_MIME;
                break;
            case 'i':
            case 'I':
                *ulOptions |= INVERTED_BM;
                iValidInput = 0;
                iState = COLLECT_EXTENSION_2;
                break;
            case 'n':
            case 'N':
                *ulOptions |= NEGATIVE_BM;
                iValidInput = 0;
                iState = COLLECT_EXTENSION_2;
                break;
            case '1':
                iValidInput++;
                break;
            case '6':
                if ((iValidInput == 1) && (cInputBuffer[0] == '1')) {
                    // 16 bit RGB565 format
                    //
                    *ulOptions |= RGB565_FORMAT;
                }
                iValidInput = 0;
                break;
            case '?':                                                    // convert "XML_file.xxx" to "XML?file"
                *ulOptions |= XML_NAME;
			default:
                iValidInput = 0;
                iState = 0;
            }
            break;

        case COLLECTING_CHARACTERISTICS:
        case COLLECTING_MIME:
            if (((cInputBuffer[iValidInput] == ' ') || (cInputBuffer[iValidInput] == _TAB)) || (cInputBuffer[iValidInput] == '/') || (cInputBuffer[iValidInput] == '\r') || (cInputBuffer[iValidInput] == '\n')) {                      // ignore white space
                int iEOL = 0;
                if ((cInputBuffer[iValidInput] == '\r') || (cInputBuffer[iValidInput] == '\n')) {
                    iEOL = 1;
                }
                cInputBuffer[iValidInput] = 0;
                if (COLLECTING_MIME == iState) {
                    strcpy(mime_type, &cInputBuffer[1]);
                }
                else {
                    strcpy(file_chars, &cInputBuffer[1]);
                }
				iState = COLLECT_EXTENSION_2;
                iValidInput = 0;
                if (iEOL != 0) {
                    if (iNewFile != 55555555) {                          // a file has been opened
                        return iNewFile;
                    }
                }
            }
            else {
                iValidInput++;
            }
            break;

        case ENTER_DEFINE:
            if ((cInputBuffer[iValidInput] == ' ') || (cInputBuffer[iValidInput] == _TAB)) { // ignore white space
                if (iValidInput != 0) {
                    cInputBuffer[iValidInput] = 0;
                    if (strcmp(cInputBuffer, "define")) {                // ignore the define keyword
                        strcpy(define_list[iDefines], cInputBuffer);     // enter the define name
                        iState = ENTER_DEFINE_VALUE;
                    }
                    iValidInput = 0;
                }
            }
            else {
                iValidInput++;
            }
            break;

        case ENTER_DEFINE_VALUE:
            if (((cInputBuffer[iValidInput] == ' ') || (cInputBuffer[iValidInput] == _TAB)) || (cInputBuffer[iValidInput] == '/') || (cInputBuffer[iValidInput] == '\r') || (cInputBuffer[iValidInput] == '\n')) {                      // ignore white space
                if (iValidInput != 0) {
                    cInputBuffer[iValidInput] = 0;
                    ulDefineValues[iDefines++] = fnGetDec(cInputBuffer);
                    iState = 0;
                    iValidInput = 0;
                }
            }
            else {
                iValidInput++;
            }
            break;

        case FLUSHING_COMMENT:
            if ((cInputBuffer[iValidInput] == '\n') || (cInputBuffer[iValidInput] == '\r')) { // end of comment found
                iState = 0;
                if (iNewFile != 55555555) {                              // a file has been opened
                    return iNewFile;
                }
            }
            break;
        }
    }
    *ulOptions |= ALL_FILES_ADDED;
    return -1;                                                           // no file found
}


static void fnPrepareTableEntry(int iCase, char *file_info, char *mime_type, char *file_chars, unsigned long ulOptions)
{
    switch (iCase) {
    case 0:
        cEntries[iEntrySize++] = '{';
        cEntries[iEntrySize++] = '"';
        strcpy(&cEntries[iEntrySize], file_info);
        if (ulOptions & XML_NAME) {                                      // change "XML_xxxx.yyy" to "XML?xxxx"
            if ((cEntries[iEntrySize] == 'X') || (cEntries[iEntrySize] == 'x')) {
                if ((cEntries[iEntrySize + 1] == 'M') || (cEntries[iEntrySize + 1] == 'M')) {
                    if ((cEntries[iEntrySize + 2] == 'L') || (cEntries[iEntrySize + 2] == 'L')) {
                        if (cEntries[iEntrySize + 3] != 0) {
                            int i = (strlen(&cEntries[iEntrySize]) - 1);
                            cEntries[iEntrySize + 3] = '?';
                            while ((cEntries[iEntrySize + i] != '.') && (cEntries[iEntrySize + i] != '?')) {
                                i--;
                            }
                            if (cEntries[iEntrySize + i] == '.') {
                                cEntries[iEntrySize + i] = 0;
                            }
                        }
                    }
                }
            }
        }
        iEntrySize = strlen(cEntries);
        cEntries[iEntrySize++] = '"';
        cEntries[iEntrySize++] = ',';
        cEntries[iEntrySize++] = ' ';
        break;

    case 1:
        strcpy(&cEntries[iEntrySize], "(unsigned char *)");
        iEntrySize += 17;        
        strcpy(&cEntries[iEntrySize], file_info);
        iEntrySize += strlen(file_info);
        strcpy(&cEntries[iEntrySize], ", sizeof(");
        iEntrySize += 9; 
        strcpy(&cEntries[iEntrySize], file_info);
        iEntrySize += strlen(file_info);
        cEntries[iEntrySize++] = ')';
        cEntries[iEntrySize++] = ',';
        cEntries[iEntrySize++] = ' ';
        strcpy(&cEntries[iEntrySize], mime_type);                        // depends on extension (after first null termination)
        iEntrySize += strlen(mime_type);
        cEntries[iEntrySize++] = ',';
        cEntries[iEntrySize++] = ' ';
        strcpy(&cEntries[iEntrySize], file_chars);  // depends on option
        iEntrySize += strlen(file_chars);
        cEntries[iEntrySize++] = '}';
        cEntries[iEntrySize++] = ',';
        cEntries[iEntrySize++] = '\r';
        cEntries[iEntrySize++] = '\n';
        break;
    }
}

unsigned long fnGetDefine(char *ptrDefine)
{
    int i;
    for (i = 0; i < iDefines; i++) {
        if (!strcmp(define_list[i], ptrDefine)) {
            return ulDefineValues[i];
        }
    }
    return 0;
}

static unsigned long fnContentSize(void)
{
    unsigned long ulTotalLength = 0;
    int i = 0;
    while (i < binary_entries) {
        ulTotalLength += binary_size[i++];
    }
    return ulTotalLength;
}

static void fnAddAdress(unsigned long ulBig, unsigned char *ptrAdd, unsigned long ulAddress)
{
    if (ulBig != 0) {
        *ptrAdd++ = (unsigned char)(ulAddress >> 24);
        *ptrAdd++ = (unsigned char)(ulAddress >> 16);
        *ptrAdd++ = (unsigned char)(ulAddress >> 8);
        *ptrAdd++ = (unsigned char)(ulAddress);
    }
    else {
        *ptrAdd++ = (unsigned char)(ulAddress);
        *ptrAdd++ = (unsigned char)(ulAddress >> 8);
        *ptrAdd++ = (unsigned char)(ulAddress >> 16);
        *ptrAdd++ = (unsigned char)(ulAddress >> 24);
    }
}

#define FILE_NOT_CODE          0x80

static unsigned long fnGenerateTable(int iBinFile)
{
    int i = 0;
    int iHeader = fnGetDefine((char *)"FILE_HEADER_LEN");
    unsigned long ulBinaryAddress = (ulFileLocationAddress + iHeader);   // the physical storage address of first binary byte
    unsigned long ulLengthField = fnGetDefine((char *)"MAX_FILE_LENGTH");
    unsigned long ulAddressMarker[128];
    unsigned long ulStringAddress;
    unsigned long ulBig = fnGetDefine((char *)"BIG_ENDIAN");
    unsigned long ulContentLocation;
    unsigned char ucAdd[4];
    char cTempstr[128];
    int iEntryCount = 0;
    int iEntryOffset = 0;
    int x;
    unsigned char ucNull = 0;
    ulStringAddress = ulBinaryAddress + fnContentSize();
                                                                         // first add strings to memory
    while (i < binary_entries ) {                                        // for each entry
        ulAddressMarker[i] = ulStringAddress;                            // mark the string address
        while (cEntries[iEntryOffset] != '{') {
            iEntryOffset++;
        }
        iEntryOffset += 2;                                               // jump string open
        while (cEntries[iEntryOffset] != '"') {
            ulBinaryAddress++;
            ulStringAddress++;
            _write(iBinFile, &cEntries[iEntryOffset++], 1);              // copy string
        }
        ulBinaryAddress++;
        ulStringAddress++;
        _write(iBinFile, &ucNull, 1);                                    // null-terminate the string
        i++;
    }

    if (fnGetDefine((char *)"ALIGN") != 0) {                             // align the table start if necessary
        unsigned char ucNull = 0x00;
        while (ulStringAddress & 0x3) {
            ulBinaryAddress++;
            ulStringAddress++;
            _write(iBinFile, &ucNull, 1);                                // pad until aligned
        }
    }

    i = 0;                                                               // now construct the table
    iEntryOffset = 0;
    ulContentLocation = (ulFileLocationAddress + iHeader);
    ulBinaryAddress = ulStringAddress;
    while (i < binary_entries ) {
        fnAddAdress(ulBig, ucAdd, ulAddressMarker[i]);                   // write the string address of file name
        _write(iBinFile, ucAdd, 4);
        ulBinaryAddress += 4;
        fnAddAdress(ulBig, ucAdd, (ulContentLocation));                  // write the address of content
        _write(iBinFile, ucAdd, 4);
        ulBinaryAddress += 4;
        ulContentLocation += binary_size[i];
        fnAddAdress(ulBig, ucAdd, binary_size[i]);                       // write the individual file size
        if (ulLengthField == 4) {
            _write(iBinFile, ucAdd, 4);
            ulBinaryAddress += 4;
        }
        else {
            if (ulBig != 0) {
                _write(iBinFile, &ucAdd[2], 2);
            }
            else {
                _write(iBinFile, ucAdd, 2);
            }
            ulBinaryAddress += 2;
        }
        while (cEntries[iEntryOffset] != ',') {                          // move to mime type location by jumping three commas plus one space
            iEntryOffset++;
        }
        iEntryOffset++;
        while (cEntries[iEntryOffset] != ',') {
            iEntryOffset++;
        }
        iEntryOffset++;
        while (cEntries[iEntryOffset] != ',') {
            iEntryOffset++;
        }
        iEntryOffset += 2;
        x = 0;
        while (cEntries[iEntryOffset] != ',') {                          // copy the mime type string content
            cTempstr[x++] = cEntries[iEntryOffset++];
        }
        cTempstr[x++] = 0;                                               // terminate the string
        ucAdd[0] = (unsigned char)fnGetDefine(cTempstr);                 // get the code value for the string
        _write(iBinFile, ucAdd, 1);
        ulBinaryAddress++;
        iEntryOffset += 2;                                               // jump space
        x = 0;
        while (cEntries[iEntryOffset] != '}') {                          // copy the characteristic type string content
            cTempstr[x++] = cEntries[iEntryOffset++];
        }
        cTempstr[x++] = 0;
        ucAdd[0] = (unsigned char)fnGetDefine(cTempstr);                 // get the code value for the string
        ucAdd[0] |= FILE_NOT_CODE;                                       // this is mainly to help the simulator
        _write(iBinFile, ucAdd, 1);
        ulBinaryAddress++;
        if (fnGetDefine((char *)"ALIGN") != 0) {                         // align the next line of the table start if necessary
            unsigned char ucNull = 0x00;
            while (ulBinaryAddress & 0x3) {
                ulBinaryAddress++;
                _write(iBinFile, &ucNull, 1);                            // pad until aligned
            }
        }
        while (cEntries[iEntryOffset] != ',') {                          // move to end of table entry by searching for the comma at the end and then moving to the line feed
            iEntryOffset++;
        }
        iEntryOffset++;
        i++;
    }
    x = 16;
    while (x--) {
        _write(iBinFile, &ucNull, 1);                                    // pad empty table line
    }
    fnAddAdress(ulBig, ucAdd, (ulStringAddress));                        // finally add a pointer to the table location
    _write(iBinFile, ucAdd, 4);
    return ulStringAddress;                                              // the address of the embedded table
}



static unsigned long fnAddTable(int theFile, int iBinFile)
{
    unsigned long ulEmbeddedTableAddress;
    _write(theFile, cCode4, (sizeof(cCode4)-1));
    _write(theFile, cEntries, iEntrySize);
    _write(theFile, cCode5, (sizeof(cCode5)-1));
    ulEmbeddedTableAddress = fnGenerateTable(iBinFile);
    _close(theFile);
    _close(iBinFile);
    return (ulEmbeddedTableAddress);
}


static void fnGenerateCode(int refFile, int theFile, char *array_name, unsigned long ulOptions, int iBinFile)
{
    static int iBinaryInput = 0;
    unsigned long ulFileLength = _read(refFile, ucInputContent, MAX_MEMORY); // read complete input content
    unsigned long ulLine;
    unsigned long ulInput = 0;
    int iOffset;
    int iLen = (sizeof(cCode1) - 1);
    char cCode2[512];
    unsigned char ucLastByte = 0xff;
    strcpy(cCode2, cCode1);
    if (array_name != 0) {                                               // if the name of the array is specified, change its name
        strcpy(&cCode2[27], array_name);
        iLen = strlen(cCode2);
        strcpy(&cCode2[iLen], &cCode1[32]);
        iLen += 8;
    }
    _write(theFile, cCode2, iLen);                                       // write the const array header
    while (ulFileLength) {
        if (ulFileLength > 32) {
            ulLine = 32;
        }
        else {
            ulLine = ulFileLength;
        }
        iOffset = 0;
        ulFileLength -= ulLine;
        while (ulLine--) {
            char cTemp;
            if (ulOptions & REMOVE_WHITE_SPACE) {
                if ((ucInputContent[ulInput] == '\r') || (ucInputContent[ulInput] == '\n') || ((ucInputContent[ulInput] == ' ') || (ucInputContent[ulInput] == _TAB))) {
                    if (ucLastByte == ' ') {
                        ulInput++;
                        continue;                                        // suppress white space in HTML files
                    }
                    ucLastByte = ' ';
                }
                else {
                    ucLastByte = 0xff;
                }
            }
            _write(iBinFile, &ucInputContent[ulInput], 1);               // write each binary byte to the uploadable file
            iBinaryInput++;
            cCode2[iOffset++] = '0';
            cCode2[iOffset++] = 'x';
            cTemp = ((ucInputContent[ulInput] >> 4) + '0');
            if (cTemp > '9') {
                cTemp += ('a' - '9' - 1);
            }
            cCode2[iOffset++] = cTemp;
            cTemp = ((ucInputContent[ulInput] & 0x0f) + '0');
            if (cTemp > '9') {
                cTemp += ('a' - '9' - 1);
            }
            cCode2[iOffset++] = cTemp;
            cCode2[iOffset++] = ',';
            ulInput++;
        }
        cCode2[iOffset++] = '\r';
        cCode2[iOffset++] = '\n';
        _write(theFile, cCode2, iOffset);
    }
    binary_size[binary_entries++] = iBinaryInput;                        // mark the size to each binary array
    iBinaryInput = 0;
    _write(theFile, cCode3, (sizeof(cCode3)-1));
}

static void fnExtendName(char file_buffer[128], int iInputFileCnt)
{
    int iLength = strlen(file_buffer);
    int i = iLength;

    while (i >= 0) {
        if ((file_buffer[i] == '?') || (file_buffer[i] == '/') || (file_buffer[i] == '\\')) {
            file_buffer[i + 1] = '_';
        }
        else {
            file_buffer[i + 1] = file_buffer[i];
        }
        i--;
    }
    file_buffer[0] = '_';
    file_buffer[iLength + 1] = 0;
    while (file_buffer[iLength] != '.') {
        iLength--;
    }
    file_buffer[iLength] = 0;
}

static void fnAddByte(unsigned char *ptrBuffer, unsigned char ucNewByte)
{
    *ptrBuffer = ((ucNewByte >> 4) + '0');
    if (*ptrBuffer > '9') {
        *ptrBuffer += ('A' - '9' - 1);
    }
    *(++ptrBuffer) = ((ucNewByte & 0x0f) + '0');
    if (*ptrBuffer > '9') {
        *ptrBuffer += ('A' - '9' - 1);
    }

}

static void fnAddBMP(int refFile, int theFile, unsigned long BMP_Length, W_BITMAPINFO *ptr_bm_info, unsigned long ulPars)
{
    unsigned char ucByte[5] = {'0', 'x', '0', '0', ','};
    unsigned char ucNextByte[4];
    unsigned char ucNextBits = 0;
    int iLine = 0;
    unsigned long ulInput = 0;
    unsigned long ulByteWidth = ptr_bm_info->biBitCount[0];
    unsigned long ulDiscard = 0;
    int iBitWidth = 1;
    int iBitsReady = 0;
    int iByte = 0;
    int iBytesToWrite = 0;
    unsigned char ucBit = 0x80;
    unsigned char ucOutBit = 0x80;
    unsigned short usWidth = ((ptr_bm_info->biWidth[1] << 8) | (ptr_bm_info->biWidth[0]));
    unsigned short usHeight = ((ptr_bm_info->biHeight[1] << 8) | (ptr_bm_info->biHeight[0]));
    unsigned short usLineLength = usWidth;
    unsigned short usPad = 0;
    switch (ulByteWidth) {
    case 24:                                                             // 24 bit color bitmap input
        ulByteWidth = 3;
        if ((RGB565_FORMAT & ulPars) != 0) {                             // if the output is to be 16 bit
            ucByte[3] = '1';                                             // the type
            usLineLength *= 3;
            usPad = ((usLineLength + 3) / 4);
            usPad *= 4;
            usPad -= usLineLength;
        }
        break;

    case 1:                                                              // one it bitmap input
        ulByteWidth = 4;
        if (usWidth >= 32) {
            iBitsReady = 32;
        }
        else {
            iBitsReady = usWidth;
        }
        usLineLength -= iBitsReady;
        iBitWidth = iBitsReady;
        break;
    }
    if (last_string[0] != 0) {
        int iLen = (sizeof(cCode1) - 1);
        char cCode2[512];
        unsigned char ucLastByte = 0xff;
        strcpy(cCode2, cCode1);
        strcpy(&cCode2[27], last_string);
        iLen = strlen(cCode2);
        strcpy(&cCode2[iLen], &cCode1[32]);
        iLen += 8;
        _write(theFile, cCode2, iLen);                                   // write the const array header
    }
    else {
        _write(theFile, cCode1, (sizeof(cCode1) - 1));
    }
    _write(theFile, ucByte, sizeof(ucByte));                             // type
    fnAddByte(&ucByte[2], ptr_bm_info->biWidth[1]);
    _write(theFile, ucByte, sizeof(ucByte));
    fnAddByte(&ucByte[2], ptr_bm_info->biWidth[0]);
    _write(theFile, ucByte, sizeof(ucByte));
    fnAddByte(&ucByte[2], ptr_bm_info->biHeight[1]);
    _write(theFile, ucByte, sizeof(ucByte));
    fnAddByte(&ucByte[2], ptr_bm_info->biHeight[0]);
    _write(theFile, ucByte, sizeof(ucByte));
    _write(theFile, &cCode3[2], 2);                                      // carriage return and line feed
    if (iBitWidth > 1) {
        _read(refFile, ucNextByte, ulByteWidth);                         // read first full byte
    }
    if (BMP_Length > ((unsigned long)usLineLength * (unsigned long)usHeight * ulByteWidth)) {
        ulDiscard = ((BMP_Length - (usLineLength * usHeight * ulByteWidth))/usHeight);
    }
    while (BMP_Length >= ulByteWidth) {
        if (iBitWidth > 1) {
            while (iBitsReady-- != 0) {
                if (ucNextByte[iByte] & ucBit) {
                    ucNextBits |= ucOutBit;                              // collect the output byte
                }
                iBytesToWrite++;
                ucBit >>= 1;
                if (ucBit == 0) {
                    ucBit = 0x80;
                    iByte++;
                }
                ucOutBit >>= 1;
                if (ucOutBit == 0) {
                    ucOutBit = 0x80;
                    if (ulPars & NEGATIVE_BM) {
                        ucNextBits = ~ucNextBits;                        // negative
                    }
                    if (ulPars & INVERTED_BM) {
                        ucInputContent[ulInput++] = ucNextBits;
                    }
                    else {
                        fnAddByte(&ucByte[2], ucNextBits);
                        _write(theFile, ucByte, sizeof(ucByte));
                    }
                    iBytesToWrite = 0;
                    ucNextBits = 0;
                }
            }
            if (iBytesToWrite != 0) {
                if (ulPars & NEGATIVE_BM) {
                    ucNextBits = ~ucNextBits;                            // negative
                }
                if (ulPars & INVERTED_BM) {
                    ucInputContent[ulInput++] = ucNextBits;
                }
                else {
                    fnAddByte(&ucByte[2], ucNextBits);
                    _write(theFile, ucByte, sizeof(ucByte));
                }
            }
            _read(refFile, ucNextByte, ulByteWidth);                     // read next full byte
            ucBit = 0x80;
            ucOutBit = 0x80;
            ucNextBits = 0;
            iByte = 0;
            if (usLineLength != 0) {
                if (usLineLength >= 32) {
                    iBitsReady = 32;
                }
                else {
                    iBitsReady = usLineLength;
                }
            }
            else {
                usLineLength = usWidth;
                if (usWidth >= 32) {
                    iBitsReady = 32;
                }
                else {
                    iBitsReady = usWidth;
                }
            }
            usLineLength -= iBitsReady;
            if ((ulPars & INVERTED_BM) == 0) {
                if (++iLine >= 30) {
                    iLine = 0;
                    _write(theFile, &cCode3[2], 2);                      // carriage return and line feed
                }
            }
        }
        else {                                                           // 24 bit bitmap
            _read(refFile, ucNextByte, ulByteWidth);                     // read next input
            iBitsReady = 0;
            if ((RGB565_FORMAT & ulPars) != 0) {
                unsigned short usColor;
                ucNextByte[0] >>= 3;                                     // red uses 5 bits
                ucNextByte[1] >>= 2;                                     // green use 6 bits
                ucNextByte[2] >>= 3;                                     // blue use 5 bits
                usColor = ucNextByte[2];
                usColor <<= 6;
                usColor |= ucNextByte[1];
                usColor <<= 5;
                usColor |= ucNextByte[0];
                if (ulPars & NEGATIVE_BM) {
                    usColor = ~usColor;                                  // negative
                }
                if (ulPars & INVERTED_BM) {
                    ucInputContent[ulInput++] = (unsigned char)(usColor >> 8);
                    ucInputContent[ulInput++] = (unsigned char)(usColor);
                }
                else {
                    fnAddByte(&ucByte[2], (unsigned char)(usColor >> 8));
                    _write(theFile, ucByte, sizeof(ucByte));
                    fnAddByte(&ucByte[2], (unsigned char)(usColor));
                    _write(theFile, ucByte, sizeof(ucByte));
                    if (++iLine >= 15) {
                        iLine = 0;
                        _write(theFile, &cCode3[2], 2);                  // carriage return and line feed
                    }
                }
                iByte += 3;
                if (iByte >= usLineLength) {
                    _read(refFile, ucNextByte, usPad);                  // discard padding
                    iByte = 0;
                    BMP_Length -= usPad;
                }
            }
            else {
                if (ucNextByte[0] != 0) {
                    ucNextBits |= ucBit;
                }
                ucBit >>= 1;
                if ((--usLineLength == 0) || (ucBit == 0)) {
                    if (ulPars & NEGATIVE_BM) {
                        ucNextBits = ~ucNextBits;                        // negative
                    }
                    if (ulPars & INVERTED_BM) {
                        ucInputContent[ulInput++] = ucNextBits;
                    }
                    else {
                        fnAddByte(&ucByte[2], ucNextBits);
                        _write(theFile, ucByte, sizeof(ucByte));

                        if (++iLine >= 30) {
                            iLine = 0;
                            _write(theFile, &cCode3[2], 2);              // carriage return and line feed
                        }
                    }
                    if (ucBit != 0) {
                        _read(refFile, ucNextByte, ulDiscard);           // discard to end of line                  
                    }
                    ucBit = 0x80;
                    if (usLineLength == 0) {
                        usLineLength = usWidth;
                    }
                    ucNextBits = 0;
                }
            }
        }
        BMP_Length -= ulByteWidth;
    }
    if ((ulPars & INVERTED_BM) != 0) {
        if ((RGB565_FORMAT & ulPars) != 0) {
            int iLine = 0;
            int iThisWidth = 0;
            unsigned long ulOutput = (ulInput - (usWidth * 2));
            while (ulInput-- != 0) {
                fnAddByte(&ucByte[2], ucInputContent[ulOutput++]);
                _write(theFile, ucByte, sizeof(ucByte));
                if (++iLine >= 30) {
                    iLine = 0;
                    _write(theFile, &cCode3[2], 2);                  // carriage return and line feed
                }
                if (++iThisWidth >= (usWidth * 2)) {
                    iThisWidth = 0;
                    ulOutput = (ulInput - (usWidth * 2));
                }
            }
        }
        else {
            unsigned short usByteWidth = ((usWidth + 7) / 8);
            unsigned long  ulRow = ((ulInput / usByteWidth) - 1);
            unsigned long  ulOutput = (ulRow * usByteWidth);
            iLine = 0;
            while (ulInput-- != 0) {
                fnAddByte(&ucByte[2], ucInputContent[ulOutput++]);
                _write(theFile, ucByte, sizeof(ucByte));
                if (--usByteWidth == 0) {
                    ulRow--;
                    usByteWidth = ((usWidth + 7) / 8);
                    ulOutput = (ulRow * usByteWidth);
                }
                if (++iLine >= 60) {
                    iLine = 0;
                    _write(theFile, &cCode3[2], 2);                      // carriage return and line feed
                }
            }
        }
    }
    _write(theFile, cCode3, (sizeof(cCode3) - 1));                       // end
}

static int fnDoBitMap(char *filename, char *outputFile, unsigned long ulPars, int _refFile, int _theFile)
{
    int refFile;
    int theFile;
    if (filename != 0) {
        last_string[0] = 0;
        refFile = _open(filename, (_O_BINARY | _O_RDONLY));
    }
    else {
        refFile = _refFile;
    }
    if (refFile < 0) {
        printf("Input bitmap file could not be found. Terminating\n\n");
        return (5);
    }
    else {
        W_BITMAPHEADER bm_header;
        W_BITMAPINFO bm_info;
        int iLen = sizeof(bm_header);
        unsigned long BMP_Length;
        unsigned short usOffset;
        _read(refFile, &bm_header, iLen);
        if ((bm_header.bmType[0] != 'B') || (bm_header.bmType[1] != 'M')) {
            printf("Input file not bitmap format. Terminating\n\n");
            _close(refFile);
            return 6;                                                // not a bit map
        }
        _read(refFile, &bm_info, sizeof(bm_info));
        if (bm_info.biCompression[0] != 0) {
            printf("Compressed bitmap not supported. Terminating\n\n");
            _close(refFile);
            return 7;                                                    // compressed bit map not supported
        }
        switch (bm_info.biBitCount[0]) {
        case 24:
            break;
        case 1:
            break;
        default:
            printf("bitmap color format not supported. Terminating\n\n");
            _close(refFile);
            return 8;                                                    // not supported color format
        }
        BMP_Length = (bm_info.biSizeImage[3] << 24);                     // bit map content length
        BMP_Length |= (bm_info.biSizeImage[2] << 16);
        BMP_Length |= (bm_info.biSizeImage[1] << 8);
        BMP_Length |= (bm_info.biSizeImage[0]);
        if (BMP_Length == 0) {
            BMP_Length = (bm_header.bmLength[3] << 24);                  // if the content length is zero, take it from the header
            BMP_Length |= (bm_header.bmLength[2] << 16);
            BMP_Length |= (bm_header.bmLength[1] << 8);
            BMP_Length |= (bm_header.bmLength[0]);
            BMP_Length -= bm_header.bmOffBits[0];
        }
        usOffset = ((bm_header.bmOffBits[1] << 8) | bm_header.bmOffBits[0]);
        if (usOffset > (sizeof(W_BITMAPHEADER) + sizeof(W_BITMAPINFO))) { // skip colour palette info
            unsigned char ucJunkByte;
            usOffset -= (sizeof(W_BITMAPHEADER) + sizeof(W_BITMAPINFO));
            if (usOffset == 8) {                                         // black-white only will have two colours
                while (usOffset--) {
                    _read(refFile, &ucJunkByte, 1);
                    if (usOffset == 5) {                                 // a 0x00 here is the case that an active pixel is white
                        if (ucJunkByte != 0) {                           // inverted content
                            ulPars ^= NEGATIVE_BM;                       // invert the image colour
                        }
                    }
                }
            }
            else {
                while (usOffset--) {
                    _read(refFile, &ucJunkByte, 1);
                }
            }
        }
        if ((outputFile != 0) && (filename != 0)) {
            theFile = _open(outputFile, (_O_BINARY | _O_TRUNC  | _O_CREAT | _O_WRONLY), _S_IWRITE); // use the final argument always as output file
        }
        else {
            theFile = _theFile;
            if ((ulPars & FIRST_FILE) != 0) {
                _write(theFile, file_header1, (sizeof(file_header1) - 1));
                _write(theFile, outputFile, strlen(outputFile));
                _write(theFile, file_header2, (sizeof(file_header2) - 1));
            }
        }
        if (theFile < 0) {
            _close(refFile);
            printf("Output file could not be created. Terminating\n\n");
            return (9);
        }
        fnAddBMP(refFile, theFile, BMP_Length, &bm_info, ulPars);        // generate the bit map content
    }
    _close(refFile);
    if ((DONT_CLOSE_OUTPUT & ulPars) == 0) {
        _close(theFile);
    }
    return 0;
}

static void fnCloseFiles(int iFile1, int iFile2, int iFile3, int iFile4)
{
    if (iFile1 >= 0) {
        _close(iFile1);
    }
    if (iFile2 >= 0) {
        _close(iFile2);
    }
    if (iFile3 >= 0) {
        _close(iFile3);
    }
    if (iFile4 >= 0) {
        _close(iFile4);
    }
}

extern int main(int argc, char* argv[])
{
    char fileName[100];
    char mime_type[32];
    char file_name[128];
    char file_chars[128];
    unsigned long ulOptions = FIRST_FILE;
	int theFile = -1;
	int refFile = -1;
    int iBinFile = -1;
    int ControlFile = -1;
    int iRtn = 0;
    int iOutputArgument = 2;
    unsigned short usFileOffset = 0;
    unsigned short usCheckSum = 0;
    int iExtraCodeLength = 0; 
    int iExtraKeyLength = 0;
    int iInputFileCnt = 1;
    char *ptr_file_name = file_name;

	if (argv[1] == 0) {
        printf("Arguments missing");
        return 0;
	}
    if (strcmp(argv[1], "-v") == 0) {                                    // display version only
        printf(SOFTWARE_VERSION);
        return 0;
    }
    if ((strcmp(argv[1], "-f") == 0) || (strcmp(argv[1], "-fb") == 0)) { // work with a control file
        int iBitmapCreate = 0;
        if (strcmp(argv[1], "-fb") == 0) {
            iBitmapCreate = 1;
        }
        iOutputArgument = 3;
	    ControlFile = _open(argv[2], (_O_RDONLY));
        if (ControlFile < 0) {
            printf("Control file could not be found. Terminating\n\n");
            return (1);
        }
        iBinFile = _open(argv[3], (_O_BINARY | _O_TRUNC  | _O_CREAT | _O_WRONLY), _S_IWRITE); // use the final argument always as output file
        if (iBinFile < 0) {
            printf("Output file could not be created. Terminating\n\n");
            return (4);
        }
        else if (iBitmapCreate == 0) {
            int iLength;
            strcpy(fileName, argv[3]);
            iLength = strlen(fileName);
            while (fileName[iLength] != '.') {
                iLength--;
            }
            strcpy(&fileName[iLength], ".c");                            // add C-file extension
        }
        if (iBitmapCreate == 0) {
            theFile = _open(fileName, (_O_BINARY | _O_TRUNC  | _O_CREAT | _O_WRONLY), _S_IWRITE); // use the final argument always as output file
            if (theFile < 0) {
                fnCloseFiles(theFile, iBinFile, ControlFile, refFile);
                printf("Output file could not be created. Terminating\n\n");
                return (4);
            }
        }
        do {
            refFile = fnGetNextInputFile(ControlFile, &ulOptions, file_name, mime_type, file_chars); // open the next file from the input list
            if ((ALL_FILES_ADDED & ulOptions) != 0) {
                if (iBitmapCreate == 0) {
                    unsigned long ulEmbeddedTableAddress = fnAddTable(theFile, iBinFile); // finally add the user file table
                    theFile = -1;
                    iBinFile = -1;
                    printf("Output files %s and %s successfully created using%s\n", argv[3], fileName, SOFTWARE_VERSION);
                    printf("Embedded user file collection target address = 0x%x\n", ulFileLocationAddress);
                    printf("Embedded user table location = 0x%x\n\n\n", ulEmbeddedTableAddress);
                }
                else {
                    printf("Output file %s successfully created using%s\n", argv[3], SOFTWARE_VERSION);
                }
                break;
            }
            if (refFile < 0) {
                printf("Specified input file number %i not found. Terminating\n\n", iInputFileCnt);
                return (2);
            }
            if (iBitmapCreate == 0) {
                if (cRename[0] != 0) {
                    ptr_file_name = cRename;
                }
                fnPrepareTableEntry(0, ptr_file_name, 0, 0, ulOptions);
                fnExtendName(ptr_file_name, iInputFileCnt);                  // add an extension to the name to ensure no doubles
                fnPrepareTableEntry(1, ptr_file_name, mime_type, file_chars, 0);
                fnGenerateCode(refFile, theFile, ptr_file_name, ulOptions, iBinFile); // generate output for the input file
                printf("Adding file %s \n", ptr_file_name);
                ulOptions |= ADD_ENTRY;
                ptr_file_name = file_name;
            }
            else {
                ulOptions |= DONT_CLOSE_OUTPUT;
                fnDoBitMap(0, argv[3], ulOptions, refFile, iBinFile);
                ulOptions &= ~FIRST_FILE;
            }
            ulOptions &= ~(XML_NAME);
        } while (1);
    }
    else if ((*argv[1] == '-') && (*(argv[1] + 1) == 'b') && (*(argv[1] + 2) == 'm')) { // bit map - monochrome
        unsigned long ulPars = 0;
        if ((*(argv[1] + 3) == 'n') || (*(argv[1] + 4) == 'n')) {
            ulPars |= NEGATIVE_BM;                                       // negative display
        }
        if ((*(argv[1] + 3) == 'i') || (*(argv[1] + 4) == 'i')) {
            ulPars |= INVERTED_BM;                                       // display inverted (bottom to top)
        }            
        return (fnDoBitMap(argv[2], argv[3], ulPars, 0, 0));
    }
    else {                                                               // use the first argument directly as input file
	    refFile = _open(argv[1], (_O_BINARY | _O_RDONLY));
        if (refFile < 0) {
            printf("Input file could not be found. Terminating\n\n");
            return (3);
        }
        theFile = _open(argv[iOutputArgument], (_O_BINARY | _O_TRUNC  | _O_CREAT | _O_WRONLY), _S_IWRITE); // use the final argument always as output file
        if (theFile < 0) {
            fnCloseFiles(theFile, iBinFile, ControlFile, refFile);
            printf("Output file could not be created. Terminating\n\n");
            return (4);
        }
        fnGenerateCode(refFile, theFile, argv[iOutputArgument + 1], 0, -1);  // generate output for the input file
        printf("Output file %s successfully generated\n\n", argv[iOutputArgument]);
    }
    fnCloseFiles(theFile, iBinFile, ControlFile, refFile);
	return (iRtn);
}



