/**********************************************************************
    Mark Butcher    Bsc (Hons) MPhil MIET

    M.J.Butcher Consulting
    Birchstrasse 20f,    CH-5406, Rtihof
    Switzerland

    www.uTasker.com    Skype: M_J_Butcher

    ---------------------------------------------------------------------
    File:        application.h
    Project:     uTasker Demonstration project
    ---------------------------------------------------------------------
    Copyright (C) M.J.Butcher Consulting 2004..2012
    *********************************************************************

    18.02.2006 Add SMTP parameter settings                               {1}
    03.06.2007 Add FTP user definable FTP timeout and ACTIVE_FTP_LOGIN   {2}
    29.06.2007 Add usUSB_state, SOURCE_USB, fnSendToUSB(), fnSetUSB_debug(),
                       ES_USB_LOGIN, ES_USB_COMMAND_MODE and USB_ON_LINE {3}
    30.10.2008 Add MODBUS (and version numbers incremented)              {4}
    20.01.2009 Add fnAddResetCause()                                     {5}
    03.02.2009 Add MODBUS parameter version number                       {6}
    11.02.2009 Add fnInitModbus()                                        {7}
    01.07.2009 Add fnDisplayBitmap()                                     {8}
    06.08.2009 MODBUS USB slave support added                            {9}
    11.08.2009 Add extra GLCD events                                     {10}
    05.02.2010 Add IPV6 settings - change ucServers to usServers         {11}
    02.10.2010 Add E_LCD_STYLE                                           {12}
    14.11.2011 Add fnSetShowTime()                                       {13}
    13.12.2011 Add ftp client parameters and iFTP_data_state             {14}
    27.12.2011 Add fnSendCAN_message()                                   {15}


*/

#define SOFTWARE_VERSION                    "V1.4.009"

#if defined USE_FTP_CLIENT && defined SMTP_PARAMETERS                    // {14} change parameter block version depending on project settings
    #define PARAMETER_BLOCK_VERSION         (unsigned char)(14)
#elif defined USE_FTP_CLIENT
    #define PARAMETER_BLOCK_VERSION         (unsigned char)(13)
#elif defined SMTP_PARAMETERS
    #define PARAMETER_BLOCK_VERSION         (unsigned char)(12)
#else
    #define PARAMETER_BLOCK_VERSION         (unsigned char)(11)
#endif                                                                   // a change in settings will cause default parameters to be used

#define MODBUS_PAR_BLOCK_VERSION            (unsigned char )1            // {6}

#define MY_PROJECT_NAME                     "uTasker Demo project"

#define VALID_VERSION_MAGIC_NUMBER          0x1234                       // {3} - check used when downloading firmware via USB

extern const CHAR cSoftwareVersion[];

#ifdef MODBUS_USB_SLAVE                                                  // {9}
    extern QUEUE_HANDLE USBPortID_comms;
#endif

extern QUEUE_TRANSFER fnSendToUSB(unsigned char *ptrData, QUEUE_TRANSFER Length); // {3}
extern void fnDownload(unsigned char *ptrData, QUEUE_TRANSFER Length);    // {3}
extern CHAR *fnSkipWhiteSpace(CHAR *ptr_input);
extern void fnEstablishDataConnection(void);
extern void fnTerminateDataConnection(void);
extern void fnEstablishManualDataConnection(unsigned char *ucDialinIP, unsigned short usSerialDialinPort);
extern void fnConfigureTelnetServer(void);
extern QUEUE_HANDLE fnSetNewSerialMode(unsigned char ucDriverMode);
extern unsigned short fnGetOurParameters(int iCase);
extern CHAR *fnUpTime(CHAR *cValue);
extern void fnConfigureFtpServer(unsigned short usTimeout);
extern void fnFlushSerialRx(void);
extern void fnSaveDebugHandle(int iState);
extern void fnRestoreDebugHandle(void);
extern void fnSetUSB_debug(void);                                        // {3}
extern int  fnCommandInput(unsigned char *ptrData, unsigned short usLen, int iSource);
    #define SOURCE_SERIAL      0
    #define SOURCE_NETWORK     1
    #define SOURCE_USB         2                                         // {3}

extern int  fnCheckTelnet(QUEUE_TRANSFER Length, UTASK_TASK Owner);
extern void fnConfigureAndStartWebServer(void);
extern int  fnInitiateLogin(unsigned short usNextState);
    #define DIRECT_LOGIN       0
    #define DO_PASSWORD_ENTRY  1
    #define TELNET_ON_LINE     2
    #define USB_ON_LINE        3                                         // {3}

extern void fnInitModbus(void);                                          // {7}
extern void fnGotoNextState(unsigned short usNextState);
extern void fnEchoInput(unsigned char *ucInputMessage, QUEUE_TRANSFER Length);
extern void fnSetDefaultNetwork(NETWORK_PARAMETERS *);
extern int  fnConfigPort(CHAR cPortBit, CHAR cType);
extern void fnSetPortOut(unsigned char ucPortOutputs, int iInitialisation);
extern int  fnTogglePortOut(CHAR cPortBit);
extern int  fnUserPortState(CHAR cPortBit);
extern int  fnPortInputConfig(CHAR cPortBit);
extern void fnSendEmail(int iRepeat);
extern void fnSavePorts(void);
extern void fnResetChanges(void);
extern void fnInitialisePorts(void);
extern void fnRestoreFactory(void);
extern int  fnPortState(CHAR cPortBit);
extern int  fnPortAnalogConfig(CHAR cPortBit);
extern int  fnAreWeValidating(void);
extern void fnWeHaveBeenValidated(void);
extern int  fnSaveNewPars(int iTemp);
extern CHAR *fnShowSN(CHAR *cValue);
extern unsigned char fnAddTime(CHAR *ptrBuffer);
extern unsigned char fnAddResetCause(CHAR *ptrBuffer);                   // {5}
extern int  fnDisplayBitmap(unsigned char *ptrData, unsigned short usLength); // {8}
extern void fnSetNewValue(int iType, CHAR *ptr_input);
    #define WAIT_BUFFER_SIZE        1
    #define WAIT_BUFFER_DELAY       2
    #define FLOW_CONTROL_HIGH_WATER 3
    #define FLOW_CONTROL_LOW_WATER  4
    #define DIAL_OUT_PORT           5
    #define DIAL_IN_PORT            6
    #define TELNET_PORT             7
extern int iGetPixelState(unsigned long ulPixelNumber);
extern unsigned char fnSetShowTime(int iSetDisplay, CHAR *ptrInput);     // {13}
    #define DISPLAY_RTC_TIME_DATE   0
    #define SET_RTC_TIME            1
extern void fnSendCAN_message(int iChannel, unsigned char ucType, unsigned char *ptrData, unsigned char ucMessageLength); // {15}


typedef struct stPARS
{
    unsigned char  ucParVersion;                                         // Versions number to avoid loading incorrect structure after major changes
    unsigned short telnet_timeout;                                       // TELNET timeout in seconds (0xffff means no timeout) - max 18 hours
    unsigned short usSerialMode;                                         // serial settings
    unsigned short usTelnetPort;                                         // the port number of our TELNET service
    unsigned short usServers;                                            // {11} active servers
    unsigned char  ucSerialSpeed;                                        // Baud rate of serial interface
    unsigned char  ucTrustedIP[IPV4_LENGTH];                             // Trusted IP address
    CHAR           cUserName[8];                                         // The single user administrator
    CHAR           cUserPass[8];                                         // The administrator's password
    CHAR           cDeviceIDName[21];                                    // 20 characters for recognition plus null terminator
    unsigned char  ucFlowHigh;                                           // High water flow level for XOFF/CTS (%)
    unsigned char  ucFlowLow;                                            // Low water flow level for XON/CTS (%)
    unsigned char  ucUserOutputs;                                        // ports set as outputs
    unsigned char  ucUserOutputValues;                                   // port values    
    unsigned short usUserDefinedOutputs;                                 // second set of user defined outputs
#ifdef SMTP_PARAMETERS                                                   // {1}
    unsigned char  ucSMTP_user_name[23];                                 // SMTP user's name plus terminator
    unsigned char  ucSMTP_password[11];                                  // SMTP user's password plus terminator
    unsigned char  ucSMTP_user_email[31];                                // SMTP user's email address plus terminator
    unsigned char  ucSMTP_server[31];                                    // SMTP server address plus terminator
    unsigned char  ucSMTP_server_ip[IPV4_LENGTH];                        // SMTP server IP address - either fixed or resolved by DNS
#endif
    unsigned char  ucGLCDContrastPWM;
    unsigned char  ucGLCDBacklightPWM;
#ifdef USE_FTP_CLIENT                                                    // {14}
    CHAR           cFTPUserName[16 + 1];                                 // the default FTP user name (up to 16 characters plus null terminator)
    CHAR           cFTPUserPass[16 + 1];                                 // the default FTP user password (up to 16 characters plus null terminator)
    unsigned short usFTPcommandPort;                                     // default FTP command port number (normally 21)
    unsigned short ftp_idle_seconds;                                     // default FTP idle timeout
    unsigned char  ucFTP_server_IP[IPV4_LENGTH];                         // default FTP server IP address
#endif
} PARS;


typedef struct stTEMPPARS
{
    NETWORK_PARAMETERS temp_network;
    PARS               temp_parameters;
#ifdef USE_MODBUS                                                        // {4}
    MODBUS_PARS        modbus_parameters;
#endif
} TEMPPARS;


                                                                         // Parameters
#define PAR_SERIAL_NUMBER 0                                              // location of serial number
#define PAR_NETWORK (PAR_SERIAL_NUMBER + sizeof(unsigned long))          // location of network parameters
#define PAR_DEVICE  (PAR_NETWORK + sizeof(NETWORK_PARAMETERS))           // location of the device parameter block
#define PAR_MODBUS  (PAR_NETWORK + sizeof(NETWORK_PARAMETERS) + sizeof(PARS)) // {4} location of the MODBUS parameter block


// ucTransferMode defines
#define AUTO_SERIAL_TO_ETHERNET         0x01
#define ACTIVE_ESCAPE_SEQUENCE_SCANNING 0x02
#define AUTO_ETHERNET_TO_SERIAL         0x04
#define RAW_SOCKET_MODE                 0x08
#define ALLOW_SERIAL_ETHERNET_DIALIN    0x10
#define ALLOW_TELNET_DIALOUT            0x20
#define TELNET_ESCAPE_SEQUENCE_SCANNING 0x80

// ucRAWMode defines
//
#define RX_TREATS_IAC                   0x01
#define TX_TREATS_IAC                   0x02

// Server defines
//
//#define SMTP_LOGIN                    0x0001                           // the smtp define is in tcpip.h (there will be a warning if not the same)
#define ACTIVE_DHCP                     0x0002                           // not a local server but means get info from a DHCP server
#define ACTIVE_FTP_SERVER               0x0004
#define ACTIVE_WEB_SERVER               0x0008
#define ACTIVE_TELNET_SERVER            0x0010
#define AUTHENTICATE_WEB_SERVER         0x0020
#define ACTIVE_LOGIN                    0x0040
#define ACTIVE_FTP_LOGIN                0x0080
#define ACTIVE_DHCPV6                   0x0100                           // {11}
#define PASSIVE_MODE_FTP_CLIENT         0x0200                           // {14} active mode rather than passive mode



extern PARS *parameters;
extern const PARS cParameters;
extern TEMPPARS *temp_pars;
extern NETWORK_PARAMETERS network_flash;
extern QUEUE_HANDLE SerialPortID;
extern CHAR cEmailAdd[41];
extern unsigned short usEthernet_Serial_state;
extern unsigned short usData_state;
extern unsigned short usUSB_state;                                       // {3}
extern int            iFTP_data_state;                                   // {14}
    #define FTP_DATA_STATE_CONNECTED 0x01
    #define FTP_DATA_STATE_GETTING   0x02
    #define FTP_DATA_STATE_PUTTING   0x04
    #define FTP_DATA_STATE_PAUSE     0x08
    #define FTP_DATA_STATE_CRITICAL  0x10
    #define FTP_DATA_STATE_CLOSING   0x20
    #define FTP_DATA_STATE_SENDING   0x40

#if defined MODBUS_DELAYED_RESPONSE && defined USE_MODBUS
    extern unsigned short usDelayedReference;
#endif
#ifdef USE_TIME_SERVER
    extern unsigned long ulPresentTime;
#endif

#ifdef USE_SMTP
    extern unsigned char ucSMTP_server[IPV4_LENGTH];
#endif

#define PASSWORD_IDLE             0
#define START_PASSWORD            1
#define ENTER_USER_NAME           2
#define ENTER_NEW_PASSWORD        3
#define CONFIRM_NEW_PASS          4
#define TELNET_LOGIN              5

// Ethernet - Serial modes
#define ES_NO_CONNECTION          0x0000
#define ES_CONNECTING_SERVER      0x0001
#define ES_CONNECTING_CLIENT      0x0002
#define ES_NETWORK_COMMAND_MODE   0x0004
#define ES_DATA_MODE              0x0008
#define ES_TERMINATE_CONNECTION   0x0010
#define ES_SERIAL_COMMAND_MODE    0x0020
#define ES_STARTING_COMMAND_MODE  0x0040
#define ES_BINARY_DATA_MODE       0x0080

#define ES_SERIAL_LOGIN           0x0100
#define ES_NETWORK_LOGIN          0x0200
#define ES_SERIAL_SUSPENDED       0x0400
#define ES_USB_LOGIN              0x0800                                 // {3}
#define ES_USB_COMMAND_MODE       0x1000                                 // {3}
#define ES_USB_DOWNLOAD_MODE      0x2000                                 // {3}
#define ES_USB_RS232_MODE         0x4000                                 // {3}


#define SAVE_NEW_PARAMETERS                0
#define SAVE_NEW_PARAMETERS_VALIDATE       1
#define SAVE_NEW_PARAMETERS_CHECK_CRITICAL 2

#define WARN_BEFORE_SAVE   0                                             // the web page warning of critical changes - deactivated
#define BAD_PASSWORD_PAGE  0                                             // the web page informing of bad passowrd entry - deactivated

#define FTP_TIMEOUT               60                                     // FTP connection times out after this delay with no activity {2}

// LCD events
// Application To LCD
#define E_LCD_COMMAND             1
#define E_LCD_TEXT                2
#define E_LCD_PATTERN             3
#define E_LCD_READ_ADDRESS        4
#define E_LCD_READ_RAM            5
#define E_LCD_COMMAND_TEXT        6
#define E_LCD_PIC                 7
#define E_LCD_LINE                8                                      // {10}
#define E_LCD_RECT                9                                      // {10}
#define E_LCD_SCROLL              10                                     // {10}
#define E_LCD_STYLE               11                                     // {}

// LDC to application
#define E_LCD_INITIALISED         1
#define E_LCD_READY               2
#define E_LCD_READ                3
#define E_LCD_ERROR               4


// Key pad events
// Keypad to application - sent as interrupt events!!
#define KEY_EVENT_COL_1_ROW_1_PRESSED  1
#define KEY_EVENT_COL_1_ROW_1_RELEASED 2
#define KEY_EVENT_COL_1_ROW_2_PRESSED  3
#define KEY_EVENT_COL_1_ROW_2_RELEASED 4
#define KEY_EVENT_COL_1_ROW_3_PRESSED  5
#define KEY_EVENT_COL_1_ROW_3_RELEASED 6
#define KEY_EVENT_COL_1_ROW_4_PRESSED  7
#define KEY_EVENT_COL_1_ROW_4_RELEASED 8

#define KEY_EVENT_COL_2_ROW_1_PRESSED  9
#define KEY_EVENT_COL_2_ROW_1_RELEASED 10
#define KEY_EVENT_COL_2_ROW_2_PRESSED  11
#define KEY_EVENT_COL_2_ROW_2_RELEASED 12
#define KEY_EVENT_COL_2_ROW_3_PRESSED  13
#define KEY_EVENT_COL_2_ROW_3_RELEASED 14
#define KEY_EVENT_COL_2_ROW_4_PRESSED  15
#define KEY_EVENT_COL_2_ROW_4_RELEASED 16

#define KEY_EVENT_COL_3_ROW_1_PRESSED  17
#define KEY_EVENT_COL_3_ROW_1_RELEASED 18
#define KEY_EVENT_COL_3_ROW_2_PRESSED  19
#define KEY_EVENT_COL_3_ROW_2_RELEASED 20
#define KEY_EVENT_COL_3_ROW_3_PRESSED  21
#define KEY_EVENT_COL_3_ROW_3_RELEASED 22
#define KEY_EVENT_COL_3_ROW_4_PRESSED  23
#define KEY_EVENT_COL_3_ROW_4_RELEASED 24

#define KEY_EVENT_COL_4_ROW_1_PRESSED  25
#define KEY_EVENT_COL_4_ROW_1_RELEASED 26
#define KEY_EVENT_COL_4_ROW_2_PRESSED  27
#define KEY_EVENT_COL_4_ROW_2_RELEASED 28
#define KEY_EVENT_COL_4_ROW_3_PRESSED  29
#define KEY_EVENT_COL_4_ROW_3_RELEASED 30
#define KEY_EVENT_COL_4_ROW_4_PRESSED  31
#define KEY_EVENT_COL_4_ROW_4_RELEASED 32

//..... up to KEY_EVENT_COL_16_ROW_16_RELEASED 128!!


#define E_SERVE_PAGE                   130                               // test
#define E_TIMER_SW_DELAYED_RESET       131

#define WAKE_UP_LITTLE_BABY            132

#define E_TEST_MODBUS_DELAY            133


