// Replace this routine in ip_utils.c to avoid the IAR4.40A ARM7 compiler problem


// tries to match a string, where lower and upper case are treated as equal
//
extern unsigned short uStrEquiv(const signed char *cInput, const signed char *cMatch)
{
    unsigned short usMatch = 0;
    signed char cReference;

    while ((cReference = *cMatch) != 0) {
        if (*cInput != cReference) {
            if (cReference >= 'a') {                                     // verify that it is not the case which doesn't match
                cReference -= ('a' - 'A');                               // try capital match
            }
            else if (cReference >= 'A') {
                cReference += ('a' - 'A');                               // try small match
            }
            if (*cInput != cReference) {                                 // last chance
                return 0;
            }
        }
        cMatch++;
        cInput++;
        usMatch++;
    }
    return usMatch;                                                      // return the length of match
}
